#property indicator_chart_window
#property indicator_buffers 8
#property indicator_color1 Red
#property indicator_width1 1
#property indicator_color2 Lime
#property indicator_width2 1
#property indicator_color3 FireBrick
#property indicator_width3 1
#property indicator_color4 Green
#property indicator_width4 1
//---- Heiken Ashi colors
#property indicator_color5 Red
#property indicator_color6 CadetBlue
#property indicator_color7 Red
#property indicator_color8 CadetBlue
//---- input parameters
extern bool      ShowComments=true;
extern string ArrowSetting  = "==ArrowSettings==";
extern int ShortTerm = 240;
extern int LongTerm = 1440;
extern string MoneyManagementSetting  = "==MoneyManagementSettings==";
extern double  Risk = 10;
extern int PairsTraded = 0;
extern string HeikenAshiSetting  = "==HeikenAshiSettings==";
extern bool ShowHeikenAshi = True;
extern string DailyRangeSetting  = "==DailyRangeSettings==";
extern bool ShowDailyRange = True;
extern color DailyRangeColor = Red;
extern string FiboPivotSetting  = "==FiboPivotSettings==";
extern bool ShowLines = True;
extern color Resistance_3 = Green;
extern color Resistance_2 = Green;
extern color Resistance_1 = Green;
extern color Pivot = Magenta;
extern color Support_1 = Red;
extern color Support_2 = Red;
extern color Support_3 = Red;

//---- buffers
double ExtMapBuffer1[];
double ExtMapBuffer2[];
double ExtMapBuffer3[];
double ExtMapBuffer4[];
//---- Heiken Ashi Buffers
double ExtMapBuffer5[];
double ExtMapBuffer6[];
double ExtMapBuffer7[];
double ExtMapBuffer8[];

int ExtCountedBars=0;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//---- indicators
   SetIndexStyle(0,DRAW_ARROW);
   SetIndexArrow(0,234);
   SetIndexBuffer(0,ExtMapBuffer1);
   SetIndexEmptyValue(0,0.0);
   SetIndexStyle(1,DRAW_ARROW);
   SetIndexArrow(1,233);
   SetIndexBuffer(1,ExtMapBuffer2);
   SetIndexEmptyValue(1,0.0);
   SetIndexStyle(2,DRAW_ARROW);
   SetIndexArrow(2,234);
   SetIndexBuffer(2,ExtMapBuffer3);
   SetIndexEmptyValue(2,0.0);
   SetIndexStyle(3,DRAW_ARROW);
   SetIndexArrow(3,233);
   SetIndexBuffer(3,ExtMapBuffer4);
   SetIndexEmptyValue(3,0.0);
//----
//---- Heiken Ashi indicators
   SetIndexStyle(4,DRAW_HISTOGRAM, 0, 1, Red);
   SetIndexBuffer(4, ExtMapBuffer5);
   SetIndexStyle(5,DRAW_HISTOGRAM, 0, 1, CadetBlue);
   SetIndexBuffer(5, ExtMapBuffer6);
   SetIndexStyle(6,DRAW_HISTOGRAM, 0, 1, Red);
   SetIndexBuffer(6, ExtMapBuffer7);
   SetIndexStyle(7,DRAW_HISTOGRAM, 0, 1, CadetBlue);
   SetIndexBuffer(7, ExtMapBuffer8);
//----
   SetIndexDrawBegin(4,5);
//---- indicator buffers mapping
   SetIndexBuffer(4,ExtMapBuffer5);
   SetIndexBuffer(5,ExtMapBuffer6);
   SetIndexBuffer(6,ExtMapBuffer7);
   SetIndexBuffer(7,ExtMapBuffer8);
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
   ObjectDelete("S1");
   ObjectDelete("S2");
   ObjectDelete("S3");
   ObjectDelete("SS");   
   ObjectDelete("R1");
   ObjectDelete("R2");
   ObjectDelete("R3");
   ObjectDelete("SR");    
   ObjectDelete("PIVOT");
   ObjectDelete("Support 1");
   ObjectDelete("Support 2");
   ObjectDelete("Support 3");
   ObjectDelete("Pivot level");
   ObjectDelete("Resistance 1");
   ObjectDelete("Resistance 2");
   ObjectDelete("Resistance 3");  
   ObjectDelete("TDR2");
   ObjectDelete("TDR2 Line"); 
   ObjectDelete("BDR2");
   ObjectDelete("BDR2 Line");    
   Comment(" ");  
   return(0);
  }
//------------------------------------------------------------------  
bool Fractal (string F,int Per, int shift)
  {
   if (Period()>Per) return(-1);

   Per=MathCeil(Per/Period());
   if (shift<Per)return(-1);
   if (shift>Bars-Per)return(-1); 
   for (int i=1;i<=Per;i++)
     {
      if (F=="U")
        {
         if (High[shift+i]>High[shift])return(-1);
         if (High[shift-i]>=High[shift])return(-1);     
        }
      if (F=="L")
        {
         if (Low[shift+i]<Low[shift])return(-1);
         if (Low[shift-i]<=Low[shift])return(-1);
        }        
     }
   return(1);   
  }  
//------------------------------------------------------------------
int start()
  {
   int B;
   double P;

   B=Bars;
   P=1*Point;
  
   for (int shift=1;shift<=B;shift++)
      {
       if (Fractal("U",ShortTerm,shift)==1) ExtMapBuffer1[shift]=High[shift]+P;
       else ExtMapBuffer1[shift]=0;
       if (Fractal("L",ShortTerm,shift)==1) ExtMapBuffer2[shift]=Low[shift]-P;
       else ExtMapBuffer2[shift]=0;
       if (Fractal("U",LongTerm,shift)==1) ExtMapBuffer3[shift]=High[shift]+P;
       else ExtMapBuffer3[shift]=0;
       if (Fractal("L",LongTerm,shift)==1) ExtMapBuffer4[shift]=Low[shift]-P;
       else ExtMapBuffer4[shift]=0;
      }

//+------------------------------------------------------------------+
//| Fibo Pivot indicator iteration function                              
//+------------------------------------------------------------------+
double rates[1][6],yesterday_close,yesterday_high,yesterday_low;
ArrayCopyRates(rates, Symbol(), PERIOD_D1);

if(DayOfWeek() == 1)
{
   if(TimeDayOfWeek(iTime(Symbol(),PERIOD_D1,1)) == 5)
   {
       yesterday_close = rates[1][4];
       yesterday_high = rates[1][3];
       yesterday_low = rates[1][2];
   }
   else
   {
      for(int d = 5;d>=0;d--)
      {
         if(TimeDayOfWeek(iTime(Symbol(),PERIOD_D1,d)) == 5)
         {
             yesterday_close = rates[d][4];
             yesterday_high = rates[d][3];
             yesterday_low = rates[d][2];
         }
         
      }  
      
   }
}
else
{
    yesterday_close = rates[1][4];
    yesterday_high = rates[1][3];
    yesterday_low = rates[1][2];
}


//---- Calculate Pivots
double R = yesterday_high - yesterday_low;//range
double p = (yesterday_high + yesterday_low + yesterday_close)/3;// Standard Pivot
double r3 = p + (R * 1.000);
double r2 = p + (R * 0.618);
double r1 = p + (R * 0.382);
double s1 = p - (R * 0.382);
double s2 = p - (R * 0.618);
double s3 = p - (R * 1.000);



double day_high=0;
double day_low=0;
double nQ=0;
double nD=0;
double D=0;
double Q=0;


double seco= (Time[4]-Time[5])-MathMod(CurTime(),Time[4]-Time[5]);
double minu=seco/60;
seco=(minu-MathFloor(minu))*60;
minu=MathFloor(minu);

day_high = rates[0][3];
day_low = rates[0][2];
D = (day_high - day_low);
Q = (yesterday_high - yesterday_low);

double fb,fs,fe,tp1,tp2,tp3;
double ri,re1,re2,re3,ra1,ra2,ra3;

if (Q > 5) 
{
	nQ = Q;
}
else
{
	nQ = Q*10000;
}

if (D > 5)
{
	nD = D;
}
else
{
	nD = D*10000;
}
 if (StringSubstr(Symbol(),3,3)=="JPY")
      {
      nQ=nQ/100;
      nD=nD/100;     
      }

if (ShowLines){
drawLine(r3,"R3", Resistance_3,1);
drawLabel("Resistance 3",r3,Resistance_3);
drawLine(r2,"R2", Resistance_2,2);
drawLabel("Resistance 2",r2,Resistance_2);
drawLine(r1,"R1", Resistance_1,0);
drawLabel("Resistance 1",r1,Resistance_1);

drawLine(p,"PIVOT",Pivot,1);
drawLabel("Pivot level",p,Pivot);

drawLine(s1,"S1",Support_1,0);
drawLabel("Support 1",s1,Support_1);
drawLine(s2,"S2",Support_2,2);
drawLabel("Support 2",s2,Support_2);
drawLine(s3,"S3",Support_3,1);
drawLabel("Support 3",s3,Support_3);
}

//+------------------------------------------------------------------+
//| Heiken Ashi indicator iteration function                              
//+------------------------------------------------------------------+
if (ShowHeikenAshi){
   double haOpen, haHigh, haLow, haClose;
   if(Bars<=10) return(0);
   ExtCountedBars=IndicatorCounted();
//---- check for possible errors
   if (ExtCountedBars<0) return(-1);
//---- last counted bar will be recounted
   if (ExtCountedBars>0) ExtCountedBars--;
   int pos=Bars-ExtCountedBars-1;
   while(pos>=0)
     {
      haOpen=(ExtMapBuffer7[pos+1]+ExtMapBuffer8[pos+1])/2;
      haClose=(Open[pos]+High[pos]+Low[pos]+Close[pos])/4;
      haHigh=MathMax(High[pos], MathMax(haOpen, haClose));
      haLow=MathMin(Low[pos], MathMin(haOpen, haClose));
      if (haOpen<haClose) 
        {
         ExtMapBuffer5[pos]=haLow;
         ExtMapBuffer6[pos]=haHigh;
        } 
      else
        {
         ExtMapBuffer5[pos]=haHigh;
         ExtMapBuffer6[pos]=haLow;
        } 
      ExtMapBuffer7[pos]=haOpen;
      ExtMapBuffer8[pos]=haClose;
 	   pos--;
     }
     }
//+------------------------------------------------------------------+
//| Money management iteration function                              
//+------------------------------------------------------------------+     
   double lotMM;
   double  lots=0.1;
   int PairsTraded;
   if(PairsTraded==0){
      lotMM = MathCeil(AccountFreeMargin() * Risk / 10000) / 10;
   } else {
      lotMM = MathCeil(AccountFreeMargin() * Risk / 10000 /PairsTraded) / 10 ;
   }
   if (lotMM < 0.1) lotMM = lots;
   if (lotMM > 1.0) lotMM = MathCeil(lotMM);
   if  (lotMM > 100) lotMM = 100;
   
//+------------------------------------------------------------------+
//| Comments iteration function                              
//+------------------------------------------------------------------+     
   if (ShowComments) 
   Comment(
   "",
   "\n==Simplistic Trading System==",   
   "\nRecommended LotSize:  ",lotMM," Lots",
   "\nTime for next bar: ",	minu," min ",seco," sec"
   );

//+------------------------------------------------------------------+
//| Daily Range iteration function                              
//+------------------------------------------------------------------+ 
      double HI2 = iHigh(NULL,1440,0);
      double LOW2 = iLow(NULL,1440,0); 
      double HI3 = iHigh(NULL,1440,0+1);
      double LOW3 = iLow(NULL,1440,0+1);
      double HI4 = iHigh(NULL,1440,0);
      double LOW4 = iLow(NULL,1440,0);
      double HI5 = iHigh(NULL,1440,2);
      double LOW5 = iLow(NULL,1440,2);
      double HI6 = iHigh(NULL,1440,3);
      double LOW6 = iLow(NULL,1440,3);
      double HI7 = iHigh(NULL,1440,4);
      double LOW7 = iLow(NULL,1440,4);
      double HI8 = iHigh(NULL,1440,5);
      double LOW8 = iLow(NULL,1440,5);
      double HI9 = iHigh(NULL,1440,6);
      double LOW9 = iLow(NULL,1440,6);
      double HI10 = iHigh(NULL,1440,7);
      double LOW10 = iLow(NULL,1440,7);
      double HI11 = iHigh(NULL,1440,8);
      double LOW11 = iLow(NULL,1440,8);
      double HI12 = iHigh(NULL,1440,9);
      double LOW12 = iLow(NULL,1440,9);
      double HI13 = iHigh(NULL,1440,10);
      double LOW13 = iLow(NULL,1440,10);
      double HI14 = iHigh(NULL,1440,11);
      double LOW14 = iLow(NULL,1440,11);
      double HI15 = iHigh(NULL,1440,12);
      double LOW15 = iLow(NULL,1440,12);
      double HI16 = iHigh(NULL,1440,13);
      double LOW16 = iLow(NULL,1440,13);
      double HI17 = iHigh(NULL,1440,14);
      double LOW17 = iLow(NULL,1440,14);
      double HI18 = iHigh(NULL,1440,15);
      double LOW18 = iLow(NULL,1440,15);
      double HI19 = iHigh(NULL,1440,16);
      double LOW19 = iLow(NULL,1440,16);
      double HI20 = iHigh(NULL,1440,17);
      double LOW20 = iLow(NULL,1440,17);
      double HI21 = iHigh(NULL,1440,18);
      double LOW21 = iLow(NULL,1440,18); 
      double HI22 = iHigh(NULL,1440,19);
      double LOW22 = iLow(NULL,1440,19);
      double HI23 = iHigh(NULL,1440,20);
      double LOW23 = iLow(NULL,1440,20);
 
      double ONE2 = (HI3-LOW3)/2;
      double FIVE2 = ((HI3-LOW3)+(HI5-LOW5)+(HI6-LOW6)+(HI7-LOW7)+(HI8-LOW8))/10;
      double TEN2 = ((HI3-LOW3)+(HI5-LOW5)+(HI6-LOW6)+(HI7-LOW7)+(HI8-LOW8)+
                    (HI9-LOW9)+(HI10-LOW10)+(HI11-LOW11)+(HI12-LOW12)+(HI13-LOW13))/20;  

  double TWENTY2 = ((HI3-LOW3)+(HI5-LOW5)+(HI6-LOW6)+(HI7-LOW7)+(HI8-LOW8)+
               (HI9-LOW9)+(HI10-LOW10)+(HI11-LOW11)+(HI12-LOW12)+(HI13-LOW13)+
               (HI14-LOW14)+(HI15-LOW15)+(HI16-LOW16)+(HI17-LOW17)+(HI18-LOW18)+
               (HI19-LOW19)+(HI20-LOW20)+(HI21-LOW21)+(HI22-LOW22)+(HI23-LOW23))/40;  
               
  double AV2 = (ONE2+FIVE2+TEN2+TWENTY2)/4;
      
  double HIDaily2 = iHigh(NULL,1440,0)-(AV2)*2; 
  double LOWDaily2 =iLow(NULL,1440,0)+(AV2)*2; 

  string TDR =   DoubleToStr(LOWDaily2,Digits);
  string BDR =   DoubleToStr(HIDaily2,Digits);
  double TDR2 =  StrToDouble(TDR);
  double BDR2 =  StrToDouble(BDR);   
  
if (ShowDailyRange){
     if(ObjectFind("TDR2") != 0)
     {
        ObjectCreate("TDR2", OBJ_TEXT, 0, Time[10], TDR2);
        ObjectSetText("TDR2", "TOP DAILY RANGE", 8, "Arial", DailyRangeColor);        
        ObjectMove("TDR2",0, Time[10], TDR2);       
     }
     else
     {
        ObjectMove("TDR2",0, Time[10],TDR2);
     }
     if(ObjectFind("TDR2 Line") != 0)
     {
        ObjectCreate("TDR2 Line", OBJ_HLINE, 0, Time[0],TDR2);
        ObjectSet("TDR2 Line", OBJPROP_STYLE, STYLE_SOLID);
        ObjectSet("TDR2 Line", OBJPROP_COLOR,DailyRangeColor );
        ObjectSet("TDR2 Line",OBJPROP_WIDTH,3);
     }
     else
     {
        ObjectMove("TDR2 Line",0, Time[0],TDR2);
     }
     
     if(ObjectFind("BDR2") != 0)
     {
        ObjectCreate("BDR2", OBJ_TEXT, 0, Time[10], BDR2);
        ObjectSetText("BDR2", "BOTTOM DAILY RANGE", 8, "Arial", DailyRangeColor);        
        ObjectMove("BDR2",0, Time[10], BDR2);       
     }
     else
     {
        ObjectMove("BDR2",0, Time[10],BDR2);
     }
     if(ObjectFind("BDR2 Line") != 0)
     {
        ObjectCreate("BDR2 Line", OBJ_HLINE, 0, Time[0],BDR2);
        ObjectSet("BDR2 Line", OBJPROP_STYLE, STYLE_SOLID);
        ObjectSet("BDR2 Line", OBJPROP_COLOR,DailyRangeColor );
        ObjectSet("BDR2 Line",OBJPROP_WIDTH,3);
     }
     else
     {
        ObjectMove("BDR2 Line",0, Time[0],BDR2);
     }     
  }      
   return(0);
  }
//+------------------------------------------------------------------+


void drawLabel(string name,double lvl,color Color)
{
    if(ObjectFind(name) != 0)
    {
        ObjectCreate(name, OBJ_TEXT, 0, Time[10], lvl);
        ObjectSetText(name, name, 8, "Arial", EMPTY);
        ObjectSet(name, OBJPROP_COLOR, Color);
    }
    else
    {
        ObjectMove(name, 0, Time[10], lvl);
    }
}


void drawLine(double lvl,string name, color Col,int type)
{
         if(ObjectFind(name) != 0)
         {
            ObjectCreate(name, OBJ_HLINE, 0, Time[0], lvl,Time[0],lvl);
            
            if(type == 1)
            ObjectSet(name, OBJPROP_STYLE, STYLE_SOLID);
            else if(type == 2)
            ObjectSet(name, OBJPROP_STYLE, STYLE_DASHDOTDOT);
            else
            ObjectSet(name, OBJPROP_STYLE, STYLE_DOT);
            
            ObjectSet(name, OBJPROP_COLOR, Col);
            ObjectSet(name,OBJPROP_WIDTH,1);
            
         }
         else
         {
            ObjectDelete(name);
            ObjectCreate(name, OBJ_HLINE, 0, Time[0], lvl,Time[0],lvl);
            
            if(type == 1)
            ObjectSet(name, OBJPROP_STYLE, STYLE_SOLID);
            else if(type == 2)
            ObjectSet(name, OBJPROP_STYLE, STYLE_DASHDOTDOT);
            else
            ObjectSet(name, OBJPROP_STYLE, STYLE_DOT);
            
            ObjectSet(name, OBJPROP_COLOR, Col);        
            ObjectSet(name,OBJPROP_WIDTH,1);
          
         }
}